/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nways.cfgman;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;

public class XmlModelProperties
extends Properties {
    private static final String[][] defaults = new String[][]{{"2210", "2210"}};
    private static final String propFileName = "XmlModels.txt";
    private static ResourceBundle myResources = null;

    public void load() throws IOException {
        File file = new File(propFileName);
        if (!file.exists()) {
            this.loadDefaults();
            this.save();
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        super.load(fileInputStream);
    }

    public void save() throws IOException {
        File file = new File(propFileName);
        if (file.exists() && !file.canWrite()) {
            Object[] objectArray = new String[]{propFileName};
            throw new IOException(XmlModelProperties.messageText("noWrite", objectArray));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        super.save(fileOutputStream, XmlModelProperties.messageText("noEdit"));
    }

    private void loadDefaults() {
        int n = 0;
        while (n < defaults.length) {
            ((Hashtable)this).put(defaults[n][0], defaults[n][1]);
            ++n;
        }
    }

    private static String messageText(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("com.ibm.nways.cfgman.XmlPropertiesResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static String messageText(String string, Object[] objectArray) {
        String string2 = null;
        string2 = MessageFormat.format(XmlModelProperties.messageText(string), objectArray);
        return string2;
    }
}

